<?php
if ( ! defined('ABSPATH') ) {
	die('Please do not load this file directly!');
}

add_action('init', 'register_testimonials_post_type');
/**
  * Register testimonials post type
*/
function register_testimonials_post_type() {
    $testimonials_slug = 'testimonials';

    $labels = array(
        'name'               => esc_html__( 'Testimonials', 'conceptseven' ),
        'singular_name'      => esc_html__( 'Testimonials Item', 'conceptseven' ),
        'add_new'            => esc_html__( 'Add New', 'conceptseven' ),
        'add_new_item'       => esc_html__( 'Add New Item', 'conceptseven' ),
        'new_item'           => esc_html__( 'New Item', 'conceptseven' ),
        'edit_item'          => esc_html__( 'Edit Item', 'conceptseven' ),
        'view_item'          => esc_html__( 'View Item', 'conceptseven' ),
        'all_items'          => esc_html__( 'All Items', 'conceptseven' ),
        'search_items'       => esc_html__( 'Search Items', 'conceptseven' ),
        'parent_item_colon'  => esc_html__( 'Parent Items:', 'conceptseven' ),
        'not_found'          => esc_html__( 'No items found.', 'conceptseven' ),
        'not_found_in_trash' => esc_html__( 'No items found in Trash.', 'conceptseven' )
    );

    $args = array(
        'labels'        => $labels,
        'rewrite'       => array( 'slug' => $testimonials_slug ),
        'supports'      => array( 'title', 'thumbnail' ),
        'public'        => true
    );

    register_post_type( 'testimonials', $args );
}

add_filter( 'post_updated_messages', 'testimonials_updated_messages' );
/**
  * Testimonials update messages.
*/
function testimonials_updated_messages( $messages ) {
    $post             = get_post();
    $post_type        = get_post_type( $post );
    $post_type_object = get_post_type_object( $post_type );

    $messages['testimonials'] = array(
        0  => '', // Unused. Messages start at index 1.
        1  => esc_html__( 'Testimonials updated.', 'conceptseven' ),
        2  => esc_html__( 'Custom field updated.', 'conceptseven' ),
        3  => esc_html__( 'Custom field deleted.', 'conceptseven' ),
        4  => esc_html__( 'Testimonials updated.', 'conceptseven' ),
        5  => isset( $_GET['revision'] ) ? sprintf( esc_html__( 'Testimonials restored to revision from %s', 'conceptseven' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => esc_html__( 'Testimonials published.', 'conceptseven' ),
        7  => esc_html__( 'Testimonials saved.', 'conceptseven' ),
        8  => esc_html__( 'Testimonials submitted.', 'conceptseven' ),
        9  => sprintf(
            esc_html__( 'Testimonials scheduled for: <strong>%1$s</strong>.', 'conceptseven' ),
            date_i18n( esc_html__( 'M j, Y @ G:i', 'conceptseven' ), strtotime( $post->post_date ) )
        ),
        10 => esc_html__( 'Testimonials draft updated.', 'conceptseven' )
    );
    return $messages;
}

add_action( 'init', 'register_testimonials_taxonomy' );
/**
  * Register testimonials taxonomy
*/
function register_testimonials_taxonomy() {
    $cat_slug = 'testimonials_category';

    $labels = array(
        'name'                       => esc_html__( 'Testimonials Categories', 'conceptseven' ),
        'singular_name'              => esc_html__( 'Category', 'conceptseven' ),
        'search_items'               => esc_html__( 'Search Categories', 'conceptseven' ),
        'menu_name'                  => esc_html__( 'Categories', 'conceptseven' ),
        'all_items'                  => esc_html__( 'All Categories', 'conceptseven' ),
        'parent_item'                => esc_html__( 'Parent Category', 'conceptseven' ),
        'parent_item_colon'          => esc_html__( 'Parent Category:', 'conceptseven' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'conceptseven' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'conceptseven' ),
        'edit_item'                  => esc_html__( 'Edit Category', 'conceptseven' ),
        'update_item'                => esc_html__( 'Update Category', 'conceptseven' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'conceptseven' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'conceptseven' ),
        'not_found'                  => esc_html__( 'No Category found.', 'conceptseven' ),
        'menu_name'                  => esc_html__( 'Categories', 'conceptseven' ),
    );
    $args = array(
        'labels'        => $labels,
        'rewrite'             => array('slug'=>$cat_slug),
        'hierarchical'  => true,
    );
    register_taxonomy( 'testimonials_category', 'testimonials', $args );
}