<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$html = $css = $data = $heading_css = $heading_cls = $desc_css = $number_css = $number_cls = $line_css = $line_cls = '';

extract( shortcode_atts( array(
	'animation' => '',
	'animation_effect' => 'fadeInUp',
	'animation_duration' => '0.75s',
	'animation_delay' => '0.3s',

	'alignment' => 'text-center',
    'number' => '',
    'number_color' => '',
    'heading' => '',
    'heading_color' => '',
    'desc' => '',
    'desc_color' => '',
	'tag' => 'h2',
	'line_width' => '100',
	'line_height' => '2',
	'line_color' => '',
	'number_font_family' => 'Default',
	'number_font_weight' => 'Default',
	'number_font_size' => '',
	'number_line_height' => '',
	'heading_font_family' => 'Default',
	'heading_font_weight' => 'Default',
	'heading_font_size' => '',
	'heading_line_height' => '',
	'desc_font_family' => 'Default',
	'desc_font_weight' => 'Default',
	'desc_font_size' => '',
	'desc_line_height' => '',
	'heading_top_margin' => '',
	'heading_bottom_margin' => '',
	'desc_top_margin' => '',
	'desc_bottom_margin' => ''
), $atts ) );

$number_font_size = intval( $number_font_size );
$number_line_height = intval( $number_line_height );
$heading_font_size = intval( $heading_font_size );
$heading_line_height = intval( $heading_line_height );
$desc_font_size = intval( $desc_font_size );
$desc_line_height = intval( $desc_line_height );

$line_width = intval( $line_width );
$line_height = intval( $line_height );

$heading_top_margin = intval( $heading_top_margin );
$heading_bottom_margin = intval( $heading_bottom_margin );
$desc_top_margin = intval( $desc_top_margin );
$desc_bottom_margin = intval( $desc_bottom_margin );

$cls = $alignment;

if ( $number_font_weight != 'Default' ) $number_css .= 'font-weight:'. $number_font_weight .';';
if ( $number_color == '#265cdc' ) { $number_cls .= ' accent';
} else { if ( $number_color ) $number_css .= 'color:'. $number_color .';'; }
if ( $number_font_size ) $number_css .= 'font-size:'. $number_font_size .'px;';
if ( $number_line_height ) $number_css .= 'line-height:'. $number_line_height .'px;';
if ( $number_font_family != 'Default' ) {
	conceptseven_enqueue_google_font( $number_font_family );
	$number_css .= 'font-family:'. $number_font_family .';';
}

if ( $heading_font_weight != 'Default' ) $heading_css .= 'font-weight:'. $heading_font_weight .';';
if ( $heading_color == '#265cdc' ) { $heading_cls .= ' accent';
} else { if ( $heading_color ) $heading_css .= 'color:'. $heading_color .';'; }
if ( $heading_font_size ) $heading_css .= 'font-size:'. $heading_font_size .'px;';
if ( $heading_line_height ) $heading_css .= 'line-height:'. $heading_line_height .'px;';
if ( $heading_top_margin ) $heading_css .= 'margin-top:'. $heading_top_margin .'px;';
if ( $heading_bottom_margin ) $heading_css .= 'margin-bottom:'. $heading_bottom_margin .'px;';
if ( $heading_font_family != 'Default' ) {
	conceptseven_enqueue_google_font( $heading_font_family );
	$heading_css .= 'font-family:'. $heading_font_family .';';
}

if ( $desc_font_weight != 'Default' ) $desc_css .= 'font-weight:'. $desc_font_weight .';';
if ( $desc_color ) $desc_css .= 'color:'. $desc_color .';';
if ( $desc_font_size ) $desc_css .= 'font-size:'. $desc_font_size .'px;';
if ( $desc_line_height ) $desc_css .= 'line-height:'. $desc_line_height .'px;';
if ( $desc_top_margin ) $desc_css .= 'margin-top:'. $desc_top_margin .'px;';
if ( $desc_bottom_margin ) $desc_css .= 'margin-bottom:'. $desc_bottom_margin .'px;';
if ( $desc_font_family != 'Default' ) {
	conceptseven_enqueue_google_font( $desc_font_family );
	$desc_css .= 'font-family:'. $desc_font_family .';';
}

if ( $line_width ) $line_css .= 'width:'. $line_width .'px;';
if ( $line_height ) $line_css .= 'height:'. $line_height .'px;';
if ( $line_color == '#265cdc' ) { $line_cls .= ' accent';
} else { if ( $line_color ) $line_css .= 'background-color:'. $line_color .';'; }

if ( $number ) $html .= sprintf(
	'<div class="numb %3$s" style="%2$s">
		%1$s
	</div>',
	$number,
	$number_css,
	$number_cls
);


if ( $heading ) $html .= sprintf(
	'<%4$s class="heading %3$s" style="%2$s">
		%1$s
	</%4$s>',
	$heading,
	$heading_css,
	$heading_cls,
	$tag
);

if ( $desc ) $html .= sprintf(
	'<p class="desc" style="%2$s">
		%1$s
	</p>',
	$desc,
	$desc_css
);

if ( $line_width && $line_height ) $html .= sprintf(
	'<div class="line %2$s" style="%1$s">
	</div>',
	$line_css,
	$line_cls
);

if ( $animation ) {
	$cls .= ' wow '. $animation_effect;
	$data .= ' data-wow-duration="'. $animation_duration .'" data-wow-delay="'. $animation_delay .'"';
}

printf(
	'<div class="conceptseven-step-box clearfix %2$s" %3$s style="%4$s">%1$s</div>',
	$html,
	$cls,
	$data,
	$css
);