<?php
/**
 * General setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Accent Colors
$this->sections['conceptseven_accent_colors'] = array(
	'title' => esc_html__( 'Accent Colors', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'accent_color',
			'default' => '#265cdc',
			'control' => array(
				'label' => esc_html__( 'Accent Color', 'conceptseven' ),
				'type' => 'color',
			),
		),
	)
);

// Favicon
$this->sections['conceptseven_favicon'] = array(
	'title' => esc_html__( 'Favicon', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'favicon',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Site Icon', 'conceptseven' ),
				'type' => 'image',
				'description' => esc_html__( 'The Site Icon is used as a browser and app icon for your site. Icons must be square, and at least 512 pixels wide and tall.', 'conceptseven' ),
			),
		),
	)
);

// PreLoader
$this->sections['conceptseven_preloader'] = array(
	'title' => esc_html__( 'PreLoader', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'preloader',
			'default' => 'animsition',
			'control' => array(
				'label' => esc_html__( 'Preloader Option', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'animsition' => esc_html__( 'Enable','conceptseven' ),
					'' => esc_html__( 'Disable','conceptseven' )
				),
			),
		),
	)
);

// Top Bar Site
$this->sections['conceptseven_topbar_site'] = array(
	'title' => esc_html__( 'Top Bar Site', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'top_bar_site_style',
			'default' => 'hide',
			'control' => array(
				'label' => esc_html__( 'Top Bar Style', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'hide' => esc_html__( 'Hide', 'conceptseven' ),
					'style-1' => esc_html__( 'Dark-Text', 'conceptseven' ),
					'style-2' => esc_html__( 'Light-Text', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Top Bar Style for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'conceptseven' )
			),
		),
	),
);

// Header Site
$this->sections['conceptseven_header_site'] = array(
	'title' => esc_html__( 'Header Site', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'header_site_style',
			'default' => 'style-1',
			'control' => array(
				'label' => esc_html__( 'Header Style', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Dark-Text', 'conceptseven' ),
					'style-2' => esc_html__( 'Light-Text', 'conceptseven' ),
					'style-3' => esc_html__( 'Transparent Dark-Text', 'conceptseven' ),
					'style-4' => esc_html__( 'Transparent Light-Text', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Header Style for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'conceptseven' )
			),
		),
		array(
			'id' => 'header_fixed',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Header Fixed: Enable', 'conceptseven' ),
				'type' => 'checkbox',
			),
		),
	),
);

// Scroll to top
$this->sections['conceptseven_scroll_top'] = array(
	'title' => esc_html__( 'Scroll Top Button', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'scroll_top',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'conceptseven' ),
				'type' => 'checkbox',
			),
		),
	),
);

// Forms
$this->sections['conceptseven_general_forms'] = array(
	'title' => esc_html__( 'Forms', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		array(
			'id' => 'input_border_rounded',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Rounded', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-radius',
			),
		),
		array(
			'id' => 'input_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'input_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'input_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'conceptseven' ),
				'description' => esc_html__( 'Enter a value in pixels. Example: 1px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'input_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'color',
			),
		),
	),
);

// Responsive
$this->sections['conceptseven_responsive'] = array(
	'title' => esc_html__( 'Responsive', 'conceptseven' ),
	'panel' => 'conceptseven_general',
	'settings' => array(
		// Top Bar
		array(
			'id' => 'heading_top_bar',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Top Bar', 'conceptseven' ),
			),
		),
		array(
			'id' => 'mobile_hide_top_bar',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Hide: Top Bar on Mobile', 'conceptseven' ),
				'type' => 'checkbox',
			),
		),
		// Mobile Button
		array(
			'id' => 'heading_mobile_button',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Mobile Button', 'conceptseven' ),
			),
		),
		array(
			'id' => 'mobile_button_color_light',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Mobile Button Color', 'conceptseven' ),
				'description' => esc_html__( 'Apply for Header 2 & 4.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two_and_four',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-2 .mobile-button:before, .header-style-2 .mobile-button:after, .header-style-2 .mobile-button span',
					'.header-style-4 .mobile-button:before, .header-style-4 .mobile-button:after, .header-style-4 .mobile-button span',
				),
				'alter' => 'background-color'
			),
		),
		array(
			'id' => 'mobile_button_color_dark',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Mobile Button Color', 'conceptseven' ),
				'description' => esc_html__( 'Apply for Header 1 & 3', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one_and_three',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 .mobile-button:before, .header-style-1 .mobile-button:after, .header-style-1 .mobile-button span',
					'.header-style-3 .mobile-button:before, .header-style-3 .mobile-button:after, .header-style-3 .mobile-button span',
				),
				'alter' => 'background-color'
			),
		),
		// Mobile Logo
		array(
			'id' => 'heading_mobile_logo',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Mobile Logo', 'conceptseven' ),
			),
		),
		array(
			'id' => 'mobile_logo_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Width', 'conceptseven' ),
				'description' => esc_html__( 'Example: 150px', 'conceptseven' ),
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo',
				'alter' => 'max-width',
			),
		),
		array(
			'id' => 'mobile_logo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Margin', 'conceptseven' ),
				'description' => esc_html__( 'Example: 20px 0px 20px 0px', 'conceptseven' ),
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo-inner',
				'alter' => 'margin',
			),
		),
		// Mobile Menu
		array(
			'id' => 'heading_mobile_menu',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Mobile Menu', 'conceptseven' ),
			),
		),
		array(
			'id' => 'mobile_menu_item_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Height', 'conceptseven' ),
				'description' => esc_html__( 'Example: 40px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav-mobi ul > li > a',
					'#main-nav-mobi .menu-item-has-children .arrow'
				),
				'alter' => 'line-height'
			),
		),
		array(
			'id' => 'mobile_menu_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo', 'conceptseven' ),
				'type' => 'image',
			),
		),
		array(
			'id' => 'mobile_menu_logo_width',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo: Width', 'conceptseven' ),
				'type' => 'text',
			),
		),
		// Featured Title
		array(
			'id' => 'heading_featured_title',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Mobile Featured Title', 'conceptseven' ),
			),
		),
		array(
			'id' => 'mobile_featured_title_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_featured_title',
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '.header-style-1 #featured-title .inner-wrap, .header-style-2 #featured-title .inner-wrap, .header-style-3 #featured-title .inner-wrap, .header-style-4 #featured-title .inner-wrap	',
				'alter' => 'padding',
			),
		),
	)
);