<?php
/**
 * Header / Logo
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define variables
$logo_url = home_url( '/' );
$logo_title = get_bloginfo( 'name' );
$logo_img = conceptseven_get_mod( 'custom_logo' );
$logo_width = conceptseven_get_mod( 'logo_width' );

// Get header style
$header_style = conceptseven_get_mod( 'header_site_style', 'style-1' );
if ( is_page() && conceptseven_metabox('header_style') )
	$header_style = conceptseven_metabox('header_style');

if ( $header_style == 'style-2' ) {
	$logo_img = conceptseven_get_mod( 'custom_logotwo' );
	$logo_width = conceptseven_get_mod( 'logotwo_width' );
}

if ( $header_style == 'style-3' ) {
	$logo_img = conceptseven_get_mod( 'custom_logothree' );
	$logo_width = conceptseven_get_mod( 'logothree_width' );
}

if ( $header_style == 'style-4' ) {
	$logo_img = conceptseven_get_mod( 'custom_logofour' );
	$logo_width = conceptseven_get_mod( 'logofour_width' );
}

// Get logo size
$logo_size = '';
if ( $logo_width )
	$logo_size .= 'max-width:'. intval( $logo_width ) .'px;';
?>

<div id="site-logo">
	<div id="site-logo-inner" style="<?php echo esc_attr( $logo_size ); ?>">
		<?php if ( $logo_img ) : ?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $logo_title ); ?>" rel="home" class="main-logo"><img src="<?php echo esc_url( $logo_img ); ?>" alt="<?php echo esc_attr( $logo_title ); ?>" /></a>
		<?php else : ?>
			<a href="<?php echo esc_url( $logo_url ); ?>" title="<?php echo esc_attr( $logo_title ); ?>" rel="home" class="site-logo-text"><?php echo esc_html( $logo_title ); ?></a>
		<?php endif; ?>
	</div>
</div><!-- #site-logo -->